#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "gga.h"


int cmd_fd = -1;		/* the fd to select on for input */

static void cmd_line(char *line);


/* initializes the commandline thread */
int
cmd_init(void)
{
	using_history();
	stifle_history(HIST_MAX);
	read_history(HIST_FILE);

	/* initialize readline */
	rl_readline_name = "gga";
/*	rl_attempted_complete_function = cmd_complete();  - XXX*/

	rl_callback_handler_install("(gga) ", cmd_line);

	cmd_fd = 0;		/* stdin */

	return 0;
}

/* like printf() (exactly like it for now) */
void
cmd_write(char *fmt,...)
{
	va_list ap;

	va_start(ap,fmt);
	vfprintf(stdout,fmt,ap);
	va_end(ap);
}

void
cmd_read(void)
{
	rl_callback_read_char();
}


void
cmd_cleanup(void)
{
	write_history(HIST_FILE);
	rl_callback_handler_remove();
}


static void
cmd_line(char *line)
{
	char *oline = line;
	int i;

	if (line == NULL) {
		/* EOF */
		do_cleanup();
	}

	i = history_expand(line, &line);
	if (line != oline)
	free(oline);
	if (i > 0) {    /* expansion was performed, so echo it */
		printf("%s\n",line);
	}
	if ((i != 0 && i != 1) || !*line) {
		free(line);
		return;
	}

	add_history(line);
	control_command(line);
}
