#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>

#include "gga.h"
#include "x.h"

Window disptrack_win;
int disptrack_scale = 500000;

static int width = 0, height = 0;

static void disptrack_doit(struct track_rec *tr, int curr_y, int track_height);
static void disptrack_draw_tics(int y);

int
disptrack_init(void)
{
	disptrack_win = XCreateSimpleWindow(x_disp,x_root_win,0,0,
				1000,500,0,
				BlackPixel(x_disp,x_screen_num),
				x_bgcol.pixel);
	XStoreName(x_disp, disptrack_win, "gga track");
	XSelectInput(x_disp, disptrack_win,
		     ExposureMask | PointerMotionMask | EnterWindowMask);
	XMapWindow(x_disp, disptrack_win);
	
	return 0;
}

void
disptrack_refresh(void)
{
	XWindowAttributes attr;
	struct track_rec *tr;
	int num_tracks = 0;
	int track_height;
	int curr_track_y;
	int n = 0;
	char buf[100];

	XGetWindowAttributes(x_disp, disptrack_win, &attr);
	width = attr.width;
	height = attr.height;

	XSetForeground(x_disp, x_gc, x_bgcol.pixel);
	XFillRectangle(x_disp, disptrack_win, x_gc, 0, 0, width, height);

	for (tr = tracks; tr; tr = tr->next)
		num_tracks++;

	if (!num_tracks) {
		return;
	}

	track_height = height / num_tracks;
	curr_track_y = 0;

	for (tr = tracks; tr; tr = tr->next) {
		/* now draw the track... */
		disptrack_doit(tr, curr_track_y+1, track_height-1);

		/* draw the separator line and the index on top of these */
		XSetForeground(x_disp, x_gc, x_blue.pixel);
		XSetFont(x_disp, x_gc, x_bigfont->fid);
		sprintf(buf,"%d",n++);
		XDrawString(x_disp, disptrack_win, x_gc, 20, curr_track_y+35,
			buf, strlen(buf));

		disptrack_draw_tics(curr_track_y-1);

		curr_track_y += track_height;
		if (curr_track_y < height) {
			XSetForeground(x_disp, x_gc, x_grey.pixel);
			XDrawLine(x_disp, disptrack_win, x_gc, 0, curr_track_y,
				     width-1, curr_track_y);
		}
	}
}

void
disptrack_location(int x,int y)
{
	double curr = ((double)x) / ((double)width) * ((double)disptrack_scale);
	char buf[20];
	int twidth;

	curr /= 1000.0;
	sprintf(buf,"%.3f",curr);
	twidth = XTextWidth(x_smallfont, buf, strlen(buf));

	XSetForeground(x_disp, x_gc, x_bgcol.pixel);
	XFillRectangle(x_disp, disptrack_win, x_gc,
		width-(50+twidth), 10, twidth+50,
		x_smallfont->ascent+x_smallfont->descent);

	XSetForeground(x_disp, x_gc, x_green.pixel);
	XSetFont(x_disp, x_gc, x_smallfont->fid);
	XDrawString(x_disp, disptrack_win, x_gc,
		    width - (10+twidth),
		    10+x_smallfont->ascent, buf, strlen(buf));
}

static void
disptrack_doit(struct track_rec *tr, int curr_y, int track_height)
{
	struct event_rec *e;
	int even = 0;
	char buf[100];

	e = tr->events;
	while (e && e->offset < disptrack_scale) {
		int x = e->offset * width / disptrack_scale;
		
		switch (e->kind) {
			case ek_sample: {
				unsigned len = ((double)e->u.sample.wav->len) * ((double)width) / ((double)disptrack_scale);
				char *name = e->u.sample.wav->name;

				if (len + x >= width)
					len = (width - x) - 1;
				XSetForeground(x_disp, x_gc, x_green.pixel);
				XFillRectangle(x_disp, disptrack_win, x_gc,
					x, curr_y + track_height/4,
					len, track_height/2);
				XSetForeground(x_disp, x_gc, x_red.pixel);
				XSetFont(x_disp, x_gc, x_smallfont->fid);
				XDrawString(x_disp, disptrack_win, x_gc,
					x+1,
					curr_y + track_height/4 +
					x_smallfont->ascent,
					name, strlen(name));
				/* XXX - maybe show more info? */
			}	break;
			case ek_stop: {
				XSetForeground(x_disp, x_gc, x_red.pixel);
				XDrawLine(x_disp, disptrack_win, x_gc,
					x, curr_y, x, curr_y+track_height);
			}	break;
			default: break;
		}
		even = !even;

		XSetForeground(x_disp, x_gc, x_green.pixel);
		sprintf(buf,"%d",e->handle);
		XSetFont(x_disp, x_gc, x_smallfont->fid);
		XDrawString(x_disp, disptrack_win, x_gc,
			x+1,
			curr_y + 1 + x_smallfont->ascent +
			(even ? 1 : x_smallfont->ascent+x_smallfont->descent),
			buf, strlen(buf));
		e = e->next;
	}
}

static void
disptrack_draw_tics(int y)
{
	int n = width/50.0;
	int i;

	XSetForeground(x_disp, x_gc, x_green.pixel);
	XSetFont(x_disp, x_gc, x_smallfont->fid);

	XDrawLine(x_disp, disptrack_win, x_gc, 0, y, width-1, y);

	for (i = 0; i < n; i++) {
		int x = i*50+25;
		double curr = (((double)x)/((double)width)) *
			      ((double)disptrack_scale);
		char buf[20];

		curr /= 1000.0;
		if (width > disptrack_scale) {
			sprintf(buf,"%.3f",curr);
		} else if (width*10 > disptrack_scale) {
			sprintf(buf,"%.2f",curr);
		} else if (width*100 > disptrack_scale) {
			sprintf(buf,"%.1f",curr);
		} else {
			sprintf(buf,"%d",(int)(curr+0.5));
		}
		XDrawLine(x_disp, disptrack_win, x_gc, x, y-4, x, y);
		XDrawString(x_disp, disptrack_win, x_gc,
			x-(XTextWidth(x_smallfont, buf, strlen(buf))/2),
			y-(2+x_smallfont->descent),
			buf, strlen(buf));
	}
}
