#include <stdio.h>
#include <string.h>
#include <math.h>
#include <X11/Xlib.h>

#include "gga.h"
#include "x.h"

/* XXX - a lot of these hardcoded constants should be based on font attrs */

Window dispwav_win;
int dispwav_scale = 10000;

static int width = 0, height = 0;

static void dispwav_doit(struct waveform_rec *w, int curr_y, int wav_height);
static void dispwav_draw_tics(int height);

int
dispwav_init(void)
{
	dispwav_win = XCreateSimpleWindow(x_disp,x_root_win,0,0,
				1000,500,0,
				BlackPixel(x_disp,x_screen_num),
				x_bgcol.pixel);
	XStoreName(x_disp, dispwav_win, "gga wav");
	XSelectInput(x_disp, dispwav_win,
		     ExposureMask | PointerMotionMask | EnterWindowMask);
	XMapWindow(x_disp, dispwav_win);
	
	return 0;
}

void
dispwav_refresh(void)
{
	XWindowAttributes attr;
	struct waveform_rec *w;
	int num_wavs = 0;
	int wav_height;
	int curr_wav_height;

	XGetWindowAttributes(x_disp, dispwav_win, &attr);
	width = attr.width;
	height = attr.height;

	XSetForeground(x_disp, x_gc, x_bgcol.pixel);
	XFillRectangle(x_disp, dispwav_win, x_gc, 0, 0, width, height);

	for (w = wavs; w; w = w->next)
		num_wavs++;

	if (!num_wavs) {
		return;
	}

	wav_height = height / num_wavs;
	curr_wav_height = 0;

	for (w = wavs; w; w = w->next) {
		/* now draw the waveform... */
		dispwav_doit(w, curr_wav_height, wav_height);

		/* draw the zero line and the name on top of these */
		XSetForeground(x_disp, x_gc, x_blue.pixel);
		XSetFont(x_disp, x_gc, x_bigfont->fid);
		XDrawString(x_disp, dispwav_win, x_gc, 20,
		        curr_wav_height+10+x_bigfont->ascent,
			w->name, strlen(w->name));

		dispwav_draw_tics(curr_wav_height+(wav_height/2));

		curr_wav_height += wav_height;
		if (curr_wav_height < height) {
			XSetForeground(x_disp, x_gc, x_grey.pixel);
			XDrawLine(x_disp, dispwav_win, x_gc, 0, curr_wav_height,
				     width-1, curr_wav_height);
		}
	}

}

void
dispwav_location(int x,int y)
{
	double curr = ((double)x) / ((double)width) * ((double)dispwav_scale);
	char buf[20];
	int twidth;

	curr /= 1000.0;
	sprintf(buf,"%.3f",curr);
	twidth = XTextWidth(x_smallfont, buf, strlen(buf));

	XSetForeground(x_disp, x_gc, x_bgcol.pixel);
	XFillRectangle(x_disp, dispwav_win, x_gc,
		width-(50+twidth), 10, twidth+50,
		x_smallfont->ascent+x_smallfont->descent);

	XSetForeground(x_disp, x_gc, x_green.pixel);
	XSetFont(x_disp, x_gc, x_smallfont->fid);
	XDrawString(x_disp, dispwav_win, x_gc,
		    width - (10+twidth),
		    10+x_smallfont->ascent, buf, strlen(buf));
}

static void
dispwav_doit(struct waveform_rec *w, int curr_y, int wav_height)
{
	int bottom = curr_y + wav_height-1;
	double per_pixel = ((double)dispwav_scale)/((double)width);
	double wav_ofs = 0.0;
	int i;
	int x;
	double rms;

	XSetForeground(x_disp, x_gc, x_red.pixel);

	for (x = 0; x < width; x++) {
		unsigned ofs_start = wav_ofs;
		unsigned ofs_stop = wav_ofs + per_pixel;
		unsigned num_samps = 0;

		if (ofs_stop <= ofs_start)
			ofs_stop++;

		rms = 0.0;
		for (i = ofs_start; i < ofs_stop; i++) {
			if (i >= w->len)
				break;
			rms += (w->data[i]*w->data[i]);
			num_samps++;
		}
		rms /= ((double)num_samps);
		rms = sqrt(rms) / 16384.0;
		rms *= ((double)wav_height);
		XDrawLine(x_disp, dispwav_win, x_gc, x, bottom,
			x, bottom-rms);

		if (i >= w->len)
			break;

		wav_ofs += per_pixel;
	}
	if (x < width) {
		XSetForeground(x_disp, x_gc, x_green.pixel);
		XDrawLine(x_disp, dispwav_win, x_gc, x, curr_y, x, bottom);
		XSetForeground(x_disp, x_gc, x_blue.pixel);
		XDrawLine(x_disp, dispwav_win, x_gc, x+1, curr_y, x+1, bottom);
	}
}

static void
dispwav_draw_tics(int y)
{
	int n = width/50.0;
	int i;

	XSetForeground(x_disp, x_gc, x_green.pixel);
	XSetFont(x_disp, x_gc, x_smallfont->fid);

	XDrawLine(x_disp, dispwav_win, x_gc, 0, y, width-1, y);

	for (i = 0; i < n; i++) {
		int x = i*50+25;
		double curr = (((double)x)/((double)width)) *
			      ((double)dispwav_scale);
		char buf[20];

		curr /= 1000.0;
		if (width > dispwav_scale) {
			sprintf(buf,"%.3f",curr);
		} else if (width*10 > dispwav_scale) {
			sprintf(buf,"%.2f",curr);
		} else if (width*100 > dispwav_scale) {
			sprintf(buf,"%.1f",curr);
		} else {
			sprintf(buf,"%d",(int)(curr+0.5));
		}
		XDrawLine(x_disp, dispwav_win, x_gc, x, y-4, x, y+4);
		XDrawString(x_disp, dispwav_win, x_gc,
			x-(XTextWidth(x_smallfont, buf, strlen(buf))/2),
			y-(2+x_smallfont->descent),
			buf, strlen(buf));
	}
}
