#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#define BUFLEN 8192
#define FRAG_LEN 13               /* 2^13 => 8192 bytes per fragment */

int
main(int argc, char **argv)
{
	char buf[BUFLEN];
	char *dev;
	int snd_fd;
	struct timeval start,tv;
	int i;

	if (argc == 1) {
		dev = "/dev/dsp";
	} else if (argc == 2) {
		dev = argv[1];
	} else {
		fprintf(stderr,"usage: %s [/dev/dspX]\n",argv[0]);
		return -1;
	}
	snd_fd = open(dev, O_RDONLY);
	if (snd_fd < 0) {
		perror(dev);
		return -1;
	}

	i = 0x7ffe0000 | FRAG_LEN;
	ioctl(snd_fd,SNDCTL_DSP_SETFRAGMENT,&i);
	if (i != (0x7ffe0000 | FRAG_LEN)) {
		perror("ioctl(SNDCTL_DSP_SETFRAGMENT,0x7ffe0000");
		return -1;
	}
	i = AFMT_S16_LE;                /* PORTABILITY -> _BE for big endian */
	ioctl(snd_fd,SNDCTL_DSP_SETFMT,&i);
	if (i != AFMT_S16_LE) {
		perror("ioctl(SNDCTL_DSP_SETFMT,AFMT_S16_LE");
		return -1;
	}
	i = 0;
	ioctl(snd_fd,SNDCTL_DSP_STEREO,&i);
	if (i != 0) {
		perror("ioctl(SNDCTL_DSP_STEREO,1");
		return -1;
	}
	i = 44100;

	ioctl(snd_fd,SNDCTL_DSP_SPEED,&i);
	if (i < 41895 || i > 46305) {   /* 5% tolerances */
		perror("ioctl(SNDCTL_DSP_SPEED,44100");
		return -1;
	}

	gettimeofday(&start,NULL);
	while ((i = read(snd_fd, buf, BUFLEN)) > 0) {
		unsigned dur;
		write(1, buf, i);
		gettimeofday(&tv,NULL);
		dur = (tv.tv_sec - start.tv_sec) * 10 +
		      ((1000000+tv.tv_usec) - start.tv_usec) / 100000 - 10;
		fprintf(stderr,"%03d.%01d      \r",dur / 10, dur % 10);
	}
	return 0;
}
