#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "gga.h"

/* track name is currently a number, just an index into the linklist */

struct track_rec *
track_find(char *name)
{
	int i = atoi(name);
	struct track_rec *t = tracks;
	struct track_rec *prev = NULL;
	while (i && t) {
		prev = t;
		t = t->next;
		i--;
	}
	if (!t && i == 0) {
		t = (struct track_rec *)malloc(sizeof *t);
		memset(t,0,sizeof *t);
		if (prev) {
			prev->next = t;
		} else {
			tracks = t;
		}
	}
	return t;
}

void
track_drop(char *name)
{
	int i = atoi(name);
	struct track_rec **t = &tracks;
	struct event_rec *e,*en;
	while (i && *t) {
		t = &((*t)->next);
		i--;
	}
	if (*t) {
		snd_stop();
		for (e = (*t)->events; e; e = en) {
			en = e->next;
			free(e);
		}
		*t = (*t)->next;
	}
}

/* this inserts the specified event into whichever track it beints in,
 * at whereever location it beints */
void
track_link(struct event_rec *e)
{
	struct event_rec **ep;
	assert(e->parent);
	ep = &(e->parent->events);
	while (*ep && (*ep)->offset < e->offset) {
		ep = &((*ep)->next);
	}
	e->next = (*ep);
	*ep = e;
}

/* removes the given event from whatever track it's in, generally so it
 * can be relinked in a new position */
void
track_unlink(struct event_rec *e)
{
	struct event_rec **ep;
	assert(e->parent);
	ep = &(e->parent->events);
	while (*ep && *ep != e) {
		ep = &((*ep)->next);
	}
	assert(*ep);		/* otherwise it doesn't exist */
	*ep = (*ep)->next;
	snd_stop();
}

/* could it possibly be any slower? */
struct event_rec *
track_event(char *name)
{
	int handle = atoi(name);
	struct track_rec *t;
	struct event_rec *e;

	for (t = tracks; t; t = t->next) {
		for (e = t->events; e; e = e->next) {
			if (e->handle == handle)
				return e;
		}
	}
	return NULL;
}
