#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>

#include "gga.h"
#include "x.h"

/* this module handles the basic communications with the x server,
 * mostly just establishing the connection and passing events to
 * one of dispwav or disptrack */

int x_fd = -1;
Display *x_disp = NULL;
int x_screen_num;
Window x_root_win;
GC x_gc;
XColor x_bgcol;
XColor x_grey;
XColor x_red;
XColor x_green;
XColor x_blue;
XFontStruct *x_bigfont;
XFontStruct *x_smallfont;



	/* XXX - consider what to do with argc/argv - Xt? */
	/* or just extract -display? */
int
x_init(int argc,char **argv)
{
	char *display_name = getenv("DISPLAY");
	Colormap cm;

	if (!(x_disp = XOpenDisplay(display_name))) {
		fprintf(stderr,"failed to connect to '%s'\n",display_name);
		return -1;
	}
	x_screen_num = DefaultScreen(x_disp);
	x_root_win = RootWindow(x_disp, x_screen_num);

	x_fd = ConnectionNumber(x_disp);

	/* allocate general gc */
	x_gc = XCreateGC(x_disp, x_root_win, 0, 0);
	XSetFillStyle(x_disp, x_gc, FillSolid);
	XSetLineAttributes(x_disp, x_gc, 1, LineSolid, CapRound, JoinRound);

	x_bigfont = XLoadQueryFont(x_disp, X_BIGFONT);
	x_smallfont = XLoadQueryFont(x_disp, X_SMALLFONT);

	/* allocate some common colors */
	cm = DefaultColormap(x_disp, x_screen_num);
	x_bgcol.red   = 0xBBBB;
	x_bgcol.green = 0xBBBB;
	x_bgcol.blue  = 0xBBBB;
	XAllocColor(x_disp, cm, &x_bgcol);
	x_grey.red   = 0x7777;
	x_grey.green = 0x7777;
	x_grey.blue  = 0x7777;
	XAllocColor(x_disp, cm, &x_grey);
	x_red.red   = 0xFFFF;
	x_red.green = 0x0000;
	x_red.blue  = 0x0000;
	XAllocColor(x_disp, cm, &x_red);
	x_green.red   = 0x0000;
	x_green.green = 0xFFFF;
	x_green.blue  = 0x0000;
	XAllocColor(x_disp, cm, &x_green);
	x_blue.red   = 0x0000;
	x_blue.green = 0x0000;
	x_blue.blue  = 0xFFFF;
	XAllocColor(x_disp, cm, &x_blue);

	return 0;
}

void
x_flush(void)
{
	XFlush(x_disp);
}

void
x_event(void)
{
	XEvent event;

	XNextEvent(x_disp,&event);

	if (event.xany.window == dispwav_win) {
		switch (event.type) {
			case Expose:
				if (event.xexpose.count == 0)
					dispwav_refresh();
				break;
			case MotionNotify:
				dispwav_location(event.xmotion.x,
						 event.xmotion.y);
				break;
			case EnterNotify:
				dispwav_location(event.xcrossing.x,
						 event.xcrossing.y);
				break;
		}
	} else if (event.xany.window == disptrack_win) {
		switch (event.type) {
			case Expose:
				if (event.xexpose.count == 0)
					disptrack_refresh();
				break;
			case MotionNotify:
				disptrack_location(event.xmotion.x,
						   event.xmotion.y);
				break;
			case EnterNotify:
				disptrack_location(event.xcrossing.x,
						   event.xcrossing.y);
				break;
		}
	}
}
