#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"

struct opinfo_rec opinfo[OP_NUMOPS] = {
	  /* op,	name,		len,	args */
	{ OP_ADD,	"ADD",		2,	2 },
	{ OP_ADDC,	"ADDC",		2,	2 },
	{ OP_AND,	"AND",		2,	2 },
	{ OP_CLR,	"CLR",		2,	1 },
	{ OP_COMF,	"COMF",		2,	-2 },
	{ OP_CMPSEQ,	"CMPSEQ",	2,	1 },
	{ OP_CMPSGT,	"CMPSGT",	2,	1 },
	{ OP_CMPSLT,	"CMPSLT",	2,	1 },
	{ OP_DECF,	"DECF",		2,	-2 },
	{ OP_DECFSZ,	"DECFSZ",	2,	-2 },
	{ OP_DECFSNZ,	"DECFSNZ",	2,	-2 },
	{ OP_INCF,	"INCF",		2,	-2 },
	{ OP_INCFSZ,	"INCFSZ",	2,	-2 },
	{ OP_INCFSNZ,	"INCFSNZ",	2,	-2 },
	{ OP_IOR,	"IOR",		2,	2 },
	{ OP_MOV,	"MOV",		-1,	2 },
	{ OP_MUL,	"MUL",		2,	2 },
	{ OP_NEG,	"NEG",		2,	1 },
	{ OP_RLF,	"RLF",		2,	-2 },
	{ OP_RLFC,	"RLFC",		2,	-2 },
	{ OP_RRF,	"RRF",		2,	-2 },
	{ OP_RRFC,	"RRFC",		2,	-2 },
	{ OP_SET,	"SET",		2,	1 },
	{ OP_SUBWB,	"SUBWB",	2,	2 },
	{ OP_SUBF,	"SUBF",		2,	2 },
	{ OP_SUBFB,	"SUBFB",	2,	2 },
	{ OP_SUBLW,	"SUBLW",	2,	1 },
	{ OP_SWAPF,	"SWAPF",	2,	-2 },
	{ OP_TSTSZ,	"TSTSZ",	2,	1 },
	{ OP_XOR,	"XOR",		2,	2 },
	{ OP_BCLR,	"BCLR",		2,	-2 },
	{ OP_BSET,	"BSET",		2,	-2 },
	{ OP_BTSC,	"BTSC",		2,	-2 },
	{ OP_BTSS,	"BTSS",		2,	-2 },
	{ OP_BTG,	"BTG",		2,	-2 },
	{ OP_BC,	"BC",		2,	1 },
	{ OP_BN,	"BN",		2,	1 },
	{ OP_BNC,	"BNC",		2,	1 },
	{ OP_BNN,	"BNN",		2,	1 },
	{ OP_BNO,	"BNO",		2,	1 },
	{ OP_BNZ,	"BNZ",		2,	1 },
	{ OP_BO,	"BO",		2,	1 },
	{ OP_BZ,	"BZ",		2,	1 },
	{ OP_GOTO,	"GOTO",		-1,	1 },
	{ OP_CALL,	"CALL",		-1,	1 },
	{ OP_FCALL,	"FCALL",	4,	1 },
	{ OP_CLRWDT,	"CLRWDT",	2,	0 },
	{ OP_DAW,	"DAW",		2,	0 },
	{ OP_NOP,	"NOP",		2,	0 },
	{ OP_PUSH,	"PUSH",		2,	0 },
	{ OP_POP,	"POP",		2,	0 },
	{ OP_RESET,	"RESET",	2,	0 },
	{ OP_RETFIE,	"RETFIE",	2,	0 },
	{ OP_FRETFIE,	"FRETFIE",	2,	0 },
	{ OP_RETLW,	"RETLW",	2,	1 },
	{ OP_RET,	"RET",		2,	0 },
	{ OP_FRET,	"FRET",		2,	0 },
	{ OP_SLEEP,	"SLEEP",	2,	0 },
	{ OP_LFSR,	"LFSR",		4,	2 },
	{ OP_LBSR,	"LBSR",		2,	1 },
	{ OP_TBLRD,	"TBLRD",	2,	0 },
	{ OP_TBLRDI,	"TBLRDI",	2,	0 },
	{ OP_TBLRDD,	"TBLRDD",	2,	0 },
	{ OP_TBLIRD,	"TBLIRD",	2,	0 },
	{ OP_TBLWT,	"TBLWT",	2,	0 },
	{ OP_TBLWTI,	"TBLWTI",	2,	0 },
	{ OP_TBLWTD,	"TBLWTD",	2,	0 },
	{ OP_TBLIWT,	"TBLIWT",	2,	0 },
	{ OP_EQU,	"EQU",		0,	1 },
	{ OP_DW,	"DW",		-1,	-1 },
	{ OP_DB,	"DB",		-1,	-1 },
	{ OP_ORG,	"ORG",		0,	1 }
};

struct inst *inst_list = NULL;
static struct inst *inst_last = NULL;


struct inst *
inst_giveme(void)
{
	struct inst *ret = safe_malloc(sizeof *ret);
	memset(ret, 0, sizeof *ret);
	return ret;
}

void
emit_inst(struct inst *i)
{
	i->next = NULL;
	if (inst_last) {
		inst_last->next = i;
	} else {
		inst_list = i;
	}
	inst_last = i;
}

void
dump_inst(FILE *f, struct inst *i)
{
	struct expr *e;

	if (!(i->flags & INST_FLAG_FINAL_ARGS)) {
		fprintf(f, "[args unresolved] ");
	}
	if (!(i->flags & INST_FLAG_FINAL_LENGTH)) {
		fprintf(f, "[length unresolved] ");
	}
	if (!(i->flags & INST_FLAG_FINAL_OFFSET)) {
		fprintf(f, "[offset unresolved] ");
	}
	if (!(i->flags & INST_FLAG_FINAL_INST)) {
		fprintf(f, "[inst unresolved] ");
	}
	if (i->sym) {
		fprintf(f, "%s: ", i->sym->label);
	}

	fprintf(f, "%-7s ", opinfo[i->op].name);

	for (e = i->args; e; e = e->next) {
		int j;

		if (e != i->args) {
			fprintf(f, ", ");
		}

		for (j = 0; j < e->num_tokens; j++) {
			switch (e->toks[j].tok) {
				case tok_num:
					fprintf(f, "%d", e->toks[j].u.num);
					break;
				case tok_str:
					fprintf(f, "\"%s\"", e->toks[j].u.str.buf);
					break;
				case tok_sym:
					fprintf(f, "%s", e->toks[j].u.sym->label);
					break;
				default:
					fprintf(f, "%s", dump_token(e->toks[j].tok));
			}
		}
	}
}


static struct symbol *dict = NULL;

struct symbol *
sym_lookup(char *name)
{
	struct symbol *s = NULL;

	for (s = dict; s; s = s->next) {
		if (!strcasecmp(s->label, name)) {
			return s;
		}
	}

		/* lookup failed, create it.. */

	s = safe_malloc(sizeof *s);
	memset(s, 0, sizeof *s);
	s->label = safe_strdup(name);
	s->next = dict;
	dict = s;

	return s;
}


/* returns OP_NUMOPS on failure, otherwise returns the OP_* enum code for
 * the op matching s */
enum op_name
op_lookup(char *s)
{
	int i;
	for (i = 0; i < OP_NUMOPS; i++) {
		if (!strcasecmp(s, opinfo[i].name))
			return opinfo[i].op;
	}
	return OP_NUMOPS;
}
