#ifndef __LEXER_H__
#define __LEXER_H__


enum token {
	tok_eof,
	tok_error,
	tok_pound,
	tok_lparen,
	tok_rparen,
	tok_comma,
	tok_equals,
	tok_plus,
	tok_minus,
	tok_star,
	tok_slash,
	tok_percent,
	tok_and,
	tok_or,
	tok_xor,
	tok_dot,
	tok_w,
	tok_num,
	tok_str,
	tok_sym,
	tok_include,
	tok_op,
	tok_newline
};

struct symbol;

extern enum token curr_token;
extern int curr_token_num;		/* tok_num */
extern char *curr_token_str;		/* tok_str */
extern int curr_token_strlen;		/* tok_str */
extern struct symbol *curr_token_sym;	/* tok_sym */
extern enum op_name curr_token_op;	/* tok_op */


void lexer_startup(void);
enum token next_token(void);
char *dump_token(enum token tok);
void do_warning(const char *fmt,...);


#endif /* __LEXER_H__ */
