#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"



static char *replace_extension(char *fn, char *ext);


int
main(int argc, char **argv)
{
	char *infn;
	char *binfn;
	char *hexfn;
	char *listfn;
	FILE *in, *bin, *hex, *list;

	if (argc != 2) {
		fprintf(stderr,"usage: %s <infile.s>\n", argv[0]);
		return -1;
	}

	infn = argv[1];

	in = fopen(infn, "r");
	if (!in) {
		perror(infn);
		return -1;
	}

		/* phase1 closes its input.. */
	phase1(in);

	phase2();

	binfn = replace_extension(infn, ".bin");
	bin = fopen(binfn, "w");
	if (!bin) {
		perror(binfn);
	}
	hexfn = replace_extension(infn, ".hex");
	hex = fopen(hexfn, "w");
	if (!hex) {
		perror(hexfn);
	}
	listfn = replace_extension(infn, ".lst");
	list = fopen(listfn, "w");
	if (!list) {
		perror(listfn);
	}

	phase3(bin, hex, list);

	fclose(bin);
	fclose(list);

	return 0;
}


static char *
replace_extension(char *fn, char *ext)
{
	char *ret = safe_malloc(strlen(fn) + strlen(ext) + 2);
	int last_dot = -1;
	int i;

	for (i = 0; fn[i]; i++) {
		if (fn[i] == '.') {
			last_dot = i;
		} else if (fn[i] == '/') {
			last_dot = -1;
		}
	}
	if (last_dot == -1) {
		last_dot = strlen(fn);
	}

	memcpy(ret, fn, last_dot);
	strcpy(ret+last_dot, ext);

	return ret;
}


void *
safe_malloc(size_t len)
{
	void *ret = malloc(len);
	assert_str((int)ret, "malloc failed!");
	return ret;
}

char *
safe_strdup(const char *s)
{
	int len = strlen(s)+1;
	char *ret = safe_malloc(len);
	memcpy(ret, s, len);
	return ret;
}

void
assert_str(int val, char *msg)
{
	if (!val) {
		fprintf(stderr,"assertion failure: %s\n",msg);
		exit(-1);
	}
}
