#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>

#define SLOW_MOVE 10
#define FAST_MOVE 100

					/* right win95 key = 116 */
#if 0
	/* keys on the lower right portion of alpha keyboard */
	/* um, for an obsolete keyboard mapping too? - Greg 2010/02/15 */
#define KC_TRIGGER	117		/* right win95 menu key */
#define KC_FAST		113		/* right Alt key ???? */
#define KC_BUTTON1	48		/* '" */
#define KC_BUTTON2	47		/* ;: */
#define KC_BUTTON3	61		/* /? */
#else
	/* keys on the numeric keypad */
#define KC_TRIGGER	90		/* 0 */
#define KC_FAST		91		/* . */
#define KC_BUTTON1	87		/* 1 */
#define KC_BUTTON2	88		/* 2 */
#define KC_BUTTON3	89		/* 3 */
#endif

#define KC_UP		111
#define KC_DOWN		116
#define KC_LEFT		113
#define KC_RIGHT	114
static int keycodes[] = {
	KC_FAST,
	KC_UP, KC_DOWN, KC_LEFT, KC_RIGHT,
	KC_BUTTON1, KC_BUTTON2, KC_BUTTON3
};


static Display *disp;
static Window root_win;

static void
grab_keys(int grab)
{
	static int grabbing_on = 0;
	int i;
	if (grab == grabbing_on) {
		/* nothing to do */
		return;
	}

	for (i = 0; i < sizeof keycodes / sizeof keycodes[0]; i++) {
		if (grab) {
			XGrabKey(disp, keycodes[i], 0, root_win, False, GrabModeAsync, GrabModeAsync);
		} else {
			XUngrabKey(disp, keycodes[i], 0, root_win);
		}
	}
	grabbing_on = grab;
}

int
main(void)
{
	char *dispname = getenv("DISPLAY");
	int screen_num;
	XEvent evt;
	int speed = SLOW_MOVE;

	if (!dispname) dispname = ":0.0";

	disp = XOpenDisplay(getenv("DISPLAY"));
	
	if (!disp) {
		fprintf(stderr,"couldn't connect to %s\n",dispname);
		return -1;
	}

	screen_num = DefaultScreen(disp);
	root_win = RootWindow(disp, screen_num);
	XTestGrabControl(disp, True);
	XGrabKey(disp, KC_TRIGGER, 0, root_win, False, GrabModeAsync, GrabModeAsync);
	while(1) {
		int press;
		int code = XNextEvent(disp, &evt);

		if (evt.type == KeyPress) {
			press = 1;
		} else if (evt.type == KeyRelease) {
			press = 0;
		} else {
			continue;
		}
		code = evt.xkey.keycode;
		switch (code) {
			case KC_TRIGGER:
				speed = SLOW_MOVE;
				grab_keys(press);
				break;
			case KC_FAST:
				if (press) {
					speed = (speed == FAST_MOVE)
							? SLOW_MOVE
							: FAST_MOVE;
				}
				break;
			case KC_UP:
				if (!press) break;
//printf("moving by %d\n", speed);
				XTestFakeRelativeMotionEvent(disp, 0,-speed,0);
				break;
			case KC_DOWN:
				if (!press) break;
				XTestFakeRelativeMotionEvent(disp, 0,speed,0);
				break;
			case KC_LEFT:
				if (!press) break;
				XTestFakeRelativeMotionEvent(disp, -speed,0,0);
				break;
			case KC_RIGHT:
				if (!press) break;
				XTestFakeRelativeMotionEvent(disp, speed,0,0);
				break;
			case KC_BUTTON1:
				XTestFakeButtonEvent(disp, 1, press ? True : False, 0);
				break;
			case KC_BUTTON2:
				XTestFakeButtonEvent(disp, 2, press ? True : False, 0);
				break;
			case KC_BUTTON3:
				XTestFakeButtonEvent(disp, 3, press ? True : False, 0);
				break;
			default: break;
		}
	}
	return 0;
}
